/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceData;
import net.nooj4nlp.controller.ConcordanceShell.RightClickPopupMenuForConcordance;
import net.nooj4nlp.controller.ConcordanceShell.TextBoxConcordanceActionListener;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ConcordanceShell;
import net.nooj4nlp.gui.shells.SyntacticTreeShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class ConcordanceShellController {
    private TextEditorShellController textController;
    private ConcordanceShell concordanceShell;
    private JRadioButton rbCharacters;
    private JRadioButton rbWordForms;
    private JTable concordanceTable;
    private JCheckBox cbMatches;
    private JCheckBox cbOutputs;
    public static Language Lan;
    private boolean RightToLeft;
    private boolean doNotRefresh = false;
    private boolean cbMatchesIsPressed = true;
    private boolean rbCharactersIsPressed = false;
    private boolean cbOutputsIsPressed = false;
    private boolean isConcordanceTableSorted = false;
    public static List<Object> theItems;
    private SyntacticTreeShell syntacticTreeShell = null;
    private static int before;
    private static int after;
    private Map<Color, Integer> colorMap = new HashMap<Color, Integer>();
    private DefaultTableModel tableModel = null;
    public static boolean isItAText;

    public ConcordanceShellController(ConcordanceShell concordanceShell) {
        this.colorMap.put(Color.BLACK, 1);
        this.colorMap.put(Color.RED, 2);
        this.colorMap.put(new Color(20, 180, 62), 3);
        this.colorMap.put(Color.BLUE, 4);
        isItAText = false;
        this.concordanceShell = concordanceShell;
        this.textController = this.concordanceShell.getTextController();
        if (this.textController != null) {
            Lan = this.textController.getMyText().Lan;
            isItAText = true;
            this.textController.setConcordanceController(this);
        }
        this.RightToLeft = ConcordanceShellController.Lan.rightToLeft;
        this.doNotRefresh = false;
        this.rbCharacters = this.concordanceShell.getRbCharacters();
        this.rbWordForms = this.concordanceShell.getRbWordForms();
        this.concordanceTable = this.concordanceShell.getConcordanceTable();
        this.concordanceTable.setFont(Launcher.preferences.TFont);
        this.cbMatches = this.concordanceShell.getCbMatches();
        this.cbOutputs = this.concordanceShell.getCbOutputs();
        if (isItAText) {
            if ((ConcordanceShellController.Lan.isoName.equals("zh") || ConcordanceShellController.Lan.isoName.equals("ja")) && !this.rbCharacters.isSelected()) {
                this.doNotRefresh = false;
                this.rbCharacters.setSelected(true);
                this.rbWordForms.setEnabled(false);
                this.doNotRefresh = true;
            } else if (ConcordanceShellController.Lan.rightToLeft) {
                DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                renderer.setHorizontalAlignment(4);
                this.concordanceTable.setDefaultRenderer(Object.class, renderer);
            } else {
                DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
                tableModel.getDataVector().removeAllElements();
                tableModel.fireTableDataChanged();
            }
        } else {
            if ((ConcordanceShellController.Lan.isoName.equals("zh") || ConcordanceShellController.Lan.isoName.equals("ja")) && !this.rbCharacters.isSelected()) {
                this.doNotRefresh = false;
                this.rbCharacters.setSelected(true);
                this.rbWordForms.setEnabled(false);
                this.doNotRefresh = true;
            }
            if (ConcordanceShellController.Lan.rightToLeft) {
                DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
                renderer.setHorizontalAlignment(4);
            } else {
                DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
                tableModel.getDataVector().removeAllElements();
                tableModel.fireTableDataChanged();
            }
        }
        theItems = new ArrayList<Object>();
    }

    public boolean AddData(Ntext text, String fileName, Color c, int tuNb, double beginAddress0, double endAddress0, ArrayList<Object> seqOfAnnotations, boolean onlyOneExample, String query) {
        Object[] item;
        Color actualColor;
        if (fileName == null) {
            fileName = "";
        }
        String lCon = "";
        String seq = "";
        String rCon = "";
        String mSeq = "";
        int beginAddress = (int)beginAddress0;
        int endAddress = (int)endAddress0;
        if ((double)endAddress < endAddress0) {
            while (endAddress < text.buffer.length() && Language.isLetter(text.buffer.charAt(endAddress))) {
                ++endAddress;
            }
        }
        seq = text.buffer.substring(beginAddress, endAddress);
        String output = "";
        if (seqOfAnnotations != null && (output = seqOfAnnotations.get(1).toString()) != null && output != "") {
            seq = seq + "/" + output;
        }
        if (onlyOneExample) {
            for (int i = 0; i < theItems.size(); i += 4) {
                String seq0;
                Object[] item2 = (Object[])theItems.get(i + 1);
                Color actualColor2 = (Color)item2[4];
                if (!actualColor2.equals(c) || !seq.equals(seq0 = item2[2].toString())) continue;
                return false;
            }
        }
        RefObject<String> lConRef = new RefObject<String>(lCon);
        RefObject<String> rConRef = new RefObject<String>(rCon);
        RefObject<String> mSeqRef = new RefObject<String>(mSeq);
        this.compute(this.rbCharacters.isSelected(), beginAddress, endAddress, text.buffer, before, after, seq, lConRef, mSeqRef, rConRef);
        lCon = (String)lConRef.argvalue;
        rCon = (String)rConRef.argvalue;
        mSeq = (String)mSeqRef.argvalue;
        int iAlready = theItems.size() - 4;
        if (iAlready >= 0 && (actualColor = (Color)(item = (Object[])theItems.get(iAlready + 1))[4]).equals(c)) {
            String fileName0 = item[0].toString();
            String lCon0 = item[1].toString();
            String seq0 = item[2].toString();
            String rCon0 = item[3].toString();
            if (fileName.equals(fileName0) && lCon.equals(lCon0) && seq.equals(seq0) && rCon.equals(rCon0)) {
                return false;
            }
        }
        Object[] cItem = new Object[6];
        ArrayList<Serializable> annotations = new ArrayList<Serializable>();
        annotations.add(Integer.valueOf(tuNb));
        annotations.add(seqOfAnnotations);
        annotations.add(Double.valueOf(beginAddress0));
        annotations.add(Double.valueOf(endAddress0));
        cItem = this.RightToLeft ? new Object[]{fileName, rCon, mSeq, lCon, c, annotations} : new Object[]{fileName, lCon, mSeq, rCon, c, annotations};
        theItems.add(query);
        theItems.add(cItem);
        theItems.add(true);
        theItems.add(output);
        return true;
    }

    public void compute(boolean characterMode, int beginAddress, int endAddress, String textBuffer, int before, int after, String result, RefObject<String> lConRef, RefObject<String> mSeqRef, RefObject<String> rConRef) {
        int index;
        mSeqRef.argvalue = "";
        rConRef.argvalue = "";
        lConRef.argvalue = "";
        int bufferLength = textBuffer.length();
        if (characterMode) {
            lConRef.argvalue = beginAddress > before ? textBuffer.substring(beginAddress - before, beginAddress) : textBuffer.substring(0, beginAddress);
            rConRef.argvalue = bufferLength > endAddress + after ? textBuffer.substring(endAddress, endAddress + after) : textBuffer.substring(endAddress, bufferLength);
        } else {
            int i;
            int nbOfTokens = 0;
            boolean inAWord = false;
            for (i = beginAddress - 1; i > 0; --i) {
                if (Language.isLetter(textBuffer.charAt(i))) {
                    if (!inAWord) {
                        ++nbOfTokens;
                    }
                    inAWord = true;
                    continue;
                }
                if (nbOfTokens >= before) break;
                if (!inAWord) continue;
                inAWord = false;
            }
            if (i < 0) {
                i = 0;
            }
            lConRef.argvalue = textBuffer.substring(i, beginAddress);
            nbOfTokens = 0;
            inAWord = true;
            for (i = endAddress; i < bufferLength; ++i) {
                if (Language.isLetter(textBuffer.charAt(i))) {
                    if (!inAWord) {
                        ++nbOfTokens;
                    }
                    inAWord = true;
                    continue;
                }
                if (nbOfTokens >= after) break;
                if (!inAWord) continue;
                inAWord = false;
            }
            if (i > bufferLength) {
                i = bufferLength;
            }
            rConRef.argvalue = textBuffer.substring(endAddress, i);
        }
        if (this.cbMatches.isSelected()) {
            index = result.indexOf(0);
            if (index == -1 || index == result.length() - 1) {
                mSeqRef.argvalue = result;
            } else {
                mSeqRef.argvalue = result.substring(0, index);
                if (this.cbOutputs.isSelected()) {
                    mSeqRef.argvalue = mSeqRef.argvalue + "/" + result.substring(index + 1);
                }
            }
        } else {
            mSeqRef.argvalue = this.cbOutputs.isSelected() ? ((index = result.indexOf(0)) == -1 || index < result.length() - 1 ? "" : result.substring(index + 1)) : "";
        }
    }

    public void refreshConcordance() {
        if (this.tableModel != null && this.isConcordanceTableSorted) {
            this.concordanceTable.setModel(this.tableModel);
            this.concordanceTable.removeColumn(this.concordanceTable.getColumnModel().getColumn(5));
            this.concordanceTable.removeColumn(this.concordanceTable.getColumnModel().getColumn(4));
            this.setConcordanceTableSorted(false);
        }
        DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
        if (this.textController != null) {
            List<Color> listOfColors = this.textController.getListOfColors();
            if (this.textController != null && listOfColors != null) {
                this.textController.setListOfColors(new ArrayList<Color>());
                this.textController.setAbsoluteBeginAddresses(new ArrayList<Integer>());
                this.textController.setAbsoluteEndAddresses(new ArrayList<Integer>());
            }
        }
        if (this.syntacticTreeShell != null) {
            this.syntacticTreeShell.dispose();
            this.setSyntacticTreeShell(null);
        }
        String lastFullPath = "";
        String lastBuffer = "";
        TextEditorShellController corpusTextController = null;
        if (corpusTextController != null) {
            lastFullPath = corpusTextController.getFileToBeOpenedOrImported().getAbsolutePath();
            lastBuffer = corpusTextController.getMyText().buffer;
        }
        if (theItems == null || theItems.size() == 0) {
            this.concordanceShell.dispose();
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Concordance is empty!", "NooJ: No match", 0);
            if (this.textController != null) {
                this.textController.setConcordanceController(null);
            }
            return;
        }
        for (int i = 0; i < theItems.size(); i += 4) {
            int absoluteEndAddress;
            Object[] item = (Object[])theItems.get(i + 1);
            boolean isSelected = (Boolean)theItems.get(i + 2);
            String fileName = item[0].toString();
            if (!isSelected) continue;
            ArrayList annotation = (ArrayList)item[5];
            ArrayList seqOfOutputs = (ArrayList)annotation.get(1);
            if (seqOfOutputs == null || seqOfOutputs.size() == 0) {
                this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(false);
                this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(false);
                RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(false);
            } else {
                String output = seqOfOutputs.get(1).toString();
                if (output == null || output.equals("")) {
                    this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(false);
                    this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(false);
                    RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(false);
                } else if (output.charAt(0) == '<' || output.charAt(0) == '$') {
                    this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(true);
                    this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(true);
                    RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(true);
                } else {
                    this.concordanceShell.getMntmAddRemoveAnnotations().setEnabled(false);
                    this.concordanceShell.getMntmDisplaySyntacticAnalysis().setEnabled(false);
                    RightClickPopupMenuForConcordance.setenableSyntacticAndAnnotations(false);
                }
            }
            String myTextBuffer = "";
            myTextBuffer = this.textController.getMyText().buffer;
            double absoluteBeginAddress0 = (Double)annotation.get(2);
            double absoluteEndAddress0 = (Double)annotation.get(3);
            int absoluteBeginAddress = (int)absoluteBeginAddress0;
            int lengthOfBuffer = myTextBuffer.length();
            if (absoluteBeginAddress > lengthOfBuffer || absoluteEndAddress > lengthOfBuffer) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Concordance is not synced with text!", "NooJ Sync Error", 0);
                return;
            }
            if ((double)absoluteEndAddress < absoluteEndAddress0) {
                for (absoluteEndAddress = (int)absoluteEndAddress0; absoluteEndAddress < lengthOfBuffer && Language.isLetter(myTextBuffer.charAt(absoluteEndAddress)); ++absoluteEndAddress) {
                }
            }
            String sOutput = "";
            ArrayList seqOfAnnotations = (ArrayList)((ArrayList)item[5]).get(1);
            if (seqOfAnnotations != null) {
                String sOutput0 = seqOfAnnotations.get(1).toString();
                sOutput = sOutput0.replace("#", "");
            }
            String lCon = "";
            String mSeq = "";
            String rCon = "";
            String seq = myTextBuffer.substring(absoluteBeginAddress, absoluteEndAddress) + "\u0000" + sOutput;
            RefObject<String> lConRef = new RefObject<String>(lCon);
            RefObject<String> rConRef = new RefObject<String>(rCon);
            RefObject<String> mSeqRef = new RefObject<String>(mSeq);
            this.compute(this.rbCharacters.isSelected(), absoluteBeginAddress, absoluteEndAddress, myTextBuffer, before, after, seq, lConRef, mSeqRef, rConRef);
            lCon = (String)lConRef.argvalue;
            rCon = (String)rConRef.argvalue;
            mSeq = (String)mSeqRef.argvalue;
            Object[] cItem = new Object[6];
            cItem = !this.RightToLeft ? new Object[]{fileName, ConcordanceShellController.cleanUpConcordanceString(lCon), ConcordanceShellController.cleanUpConcordanceString(mSeq), ConcordanceShellController.cleanUpConcordanceString(rCon), this.colorMap.get(item[4]), item[5]} : new Object[]{fileName, ConcordanceShellController.cleanUpConcordanceString(rCon), ConcordanceShellController.cleanUpConcordanceString(mSeq), ConcordanceShellController.cleanUpConcordanceString(lCon), this.colorMap.get(item[4]), item[5]};
            this.concordanceShell.getCustomForegroundTableRenderer().addColoredRowsToAMap(tableModel.getRowCount(), (Color)item[4]);
            tableModel.addRow(cItem);
        }
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 0);
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 1);
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 2);
        this.setWidthOfTableColumn(this.concordanceTable, tableModel, 3);
        this.setTableModel(null);
        this.concordanceShell.getEntriesNBLabel().setText(this.concordanceTable.getRowCount() + "/" + theItems.size() / 4);
        this.mColorClick();
        this.concordanceShell.setVisible(true);
        if (this.textController.isColored()) {
            TextEditorShell.mntmExportColoredTexts.setEnabled(true);
        }
    }

    public static String cleanUpConcordanceString(String text) {
        StringBuilder sb = new StringBuilder(text);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (!Character.isISOControl(c) && !Character.isWhitespace(c)) continue;
            sb.setCharAt(i, ' ');
        }
        return sb.toString();
    }

    public void radioButtonEvent(boolean isRBCharactersSelected) {
        if (isRBCharactersSelected) {
            before *= 10;
            after *= 10;
            this.rbCharactersIsPressed = true;
        } else {
            before = (before - before % 10) / 10;
            after = (after - after % 10) / 10;
            this.rbCharactersIsPressed = false;
        }
        if (this.doNotRefresh) {
            return;
        }
        this.refreshConcordance();
    }

    public void setWidthOfTableColumn(JTable table, DefaultTableModel tableModel, int column) {
        int width = 0;
        for (int row = 0; row < tableModel.getRowCount(); ++row) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width, width);
        }
        if (column == 0 && width < 50) {
            width = 50;
        } else if (width < 166) {
            width = 166;
        }
        if (column == 2 && !this.cbMatchesIsPressed) {
            width = 50;
        }
        table.getColumnModel().getColumn(column).setMaxWidth(width + 5);
        table.getColumnModel().getColumn(column).setPreferredWidth(width + 5);
    }

    public void annotate() {
        int iAdded = 0;
        int iRemoved = 0;
        RefObject<Integer> iAddedRef = new RefObject<Integer>(iAdded);
        RefObject<Integer> iRemovedRef = new RefObject<Integer>(iRemoved);
        ArrayList<Object> annotations = this.textController.getMyText().annotations;
        String lastFullPath = "";
        Ntext myLastText = null;
        if (this.textController != null) {
            lastFullPath = this.textController.getFileToBeOpenedOrImported().getAbsolutePath();
            myLastText = this.textController.getMyText();
        }
        Engine engine = null;
        boolean processAll = false;
        int[] selectedRows = this.concordanceTable.getSelectedRows();
        int selectedRowsLength = selectedRows.length;
        if (selectedRowsLength == 0) {
            processAll = true;
        }
        for (int i = 0; i < this.concordanceTable.getRowCount(); ++i) {
            DefaultTableModel tableModel;
            ArrayList annotation;
            int TUnb;
            if (!processAll && !this.concordanceTable.isRowSelected(i) || (TUnb = ((Integer)(annotation = (ArrayList)(tableModel = (DefaultTableModel)this.concordanceTable.getModel()).getValueAt(i, 5)).get(0)).intValue()) <= 0) continue;
            engine = this.textController.getEngine();
            Ntext myText = this.textController.getMyText();
            int xRefNb = myText.annotations.size();
            ArrayList seqOfAnnotations = (ArrayList)annotation.get(1);
            if (seqOfAnnotations == null) continue;
            String seq = seqOfAnnotations.get(1).toString();
            if (seqOfAnnotations.size() <= 4) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Output \"" + seq + "\" is not a proper annotation command!", "NooJ stopped annotating the corpus", 0);
                break;
            }
            if (seq.charAt(0) != '<') {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Output \"" + seqOfAnnotations.get(1) + "\" is not a proper annotation command!", "NooJ stopped annotating the corpus", 0);
                break;
            }
            this.annotationHelpFunction(engine, myText, seqOfAnnotations, annotations, TUnb, xRefNb, iAddedRef, iRemovedRef, true);
        }
        iAdded = (Integer)iAddedRef.argvalue;
        iRemoved = (Integer)iRemovedRef.argvalue;
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), iAdded + " annotations were added; " + iRemoved + " annotations were removed", "NooJ: text was annotated", 1);
        if (iAdded > 0 || iRemoved > 0) {
            this.textController.updateTextPaneStats();
            this.textController.modify();
        }
    }

    private void annotationHelpFunction(Engine engine, Ntext myText, ArrayList<?> seqOfAnnotations, ArrayList<Object> annotations, int TUnb, int xRefNb, RefObject<Integer> iAddedRef, RefObject<Integer> iRemovedRef, boolean corpusContextCall) {
        int ia;
        RefObject<Integer> refObject;
        for (int ia2 = 4; ia2 < seqOfAnnotations.size(); ia2 += 3) {
            double absoluteBeginAddress = (Double)seqOfAnnotations.get(ia2);
            RefObject<Double> absBegAddressRef = new RefObject<Double>(absoluteBeginAddress);
            engine.moveBegAddressOufOfSpaces(myText.buffer, myText.XmlNodes != null, absBegAddressRef);
            absoluteBeginAddress = (Double)absBegAddressRef.argvalue;
            String sOutput = seqOfAnnotations.get(ia2 + 1).toString();
            double absoluteEndAddress = (Double)seqOfAnnotations.get(ia2 + 2);
            if (absoluteBeginAddress != absoluteEndAddress) continue;
            long hund_BeginAddress = (long)((absoluteBeginAddress + 0.005) * 100.0) - (long)(100 * myText.mft.tuAddresses[TUnb]);
            double beginAddress = (double)hund_BeginAddress / 100.0;
            boolean anXRefWasRemoved = false;
            RefObject<Boolean> anXRefWasRemovedRef = new RefObject<Boolean>(anXRefWasRemoved);
            refObject = iRemovedRef;
            Integer.valueOf((Integer)refObject.argvalue + myText.mft.filterTransitions(myText.annotations, TUnb, beginAddress, sOutput, anXRefWasRemovedRef));
            refObject.argvalue = refObject.argvalue;
            anXRefWasRemoved = (Boolean)anXRefWasRemovedRef.argvalue;
        }
        int nbXRef = 0;
        for (ia = 4; ia < seqOfAnnotations.size(); ia += 3) {
            String sOutput = seqOfAnnotations.get(ia + 1).toString();
            if (sOutput.equals("") || sOutput.indexOf("XREF") == -1) continue;
            ++nbXRef;
        }
        for (ia = 4; ia < seqOfAnnotations.size(); ia += 3) {
            double absoluteBeginAddress = (Double)seqOfAnnotations.get(ia);
            RefObject<Double> absBegAddressRef = new RefObject<Double>(absoluteBeginAddress);
            engine.moveBegAddressOufOfSpaces(myText.buffer, myText.XmlNodes != null, absBegAddressRef);
            absoluteBeginAddress = (Double)absBegAddressRef.argvalue;
            String sOutput = seqOfAnnotations.get(ia + 1).toString();
            double absoluteEndAddress = (Double)seqOfAnnotations.get(ia + 2);
            if (!(absoluteBeginAddress < absoluteEndAddress)) continue;
            double relativeBeginAddress = absoluteBeginAddress - (double)myText.mft.tuAddresses[TUnb];
            double relativeEndAddress = absoluteEndAddress - (double)myText.mft.tuAddresses[TUnb];
            if (!corpusContextCall && myText.hPhrases == null) {
                myText.hPhrases = new HashMap();
            }
            String sInput = Dic.cleanupEntry(myText.buffer.substring((int)absoluteBeginAddress, (int)absoluteEndAddress));
            if (!sOutput.equals("") && sOutput.indexOf("XREF") != -1) {
                sOutput = sOutput.replace("XREF", "XREF=" + xRefNb + "." + nbXRef);
            }
            sOutput = Dic.cleanUpDoubleQuotes(sOutput);
            engine.addLexemeToText(annotations, myText.hPhrases, sInput + ",SYNTAX," + sOutput, myText.mft, TUnb, relativeBeginAddress, relativeEndAddress);
            refObject = iAddedRef;
            Integer n = (Integer)refObject.argvalue;
            refObject.argvalue = (Integer)refObject.argvalue + 1;
            Integer n2 = refObject.argvalue;
        }
    }

    public void reset() {
        for (int i = 0; i < theItems.size(); i += 4) {
            theItems.set(i + 2, true);
        }
        JTextField beforeTF = this.concordanceShell.getBeforeTF();
        JTextField afterTF = this.concordanceShell.getAfterTF();
        TextBoxConcordanceActionListener textBoxConcordanceActionListener = (TextBoxConcordanceActionListener)this.concordanceShell.getBeforeTF().getKeyListeners()[0];
        textBoxConcordanceActionListener.reset(beforeTF, afterTF);
    }

    private void mColorClick() {
        this.textController.setListOfColors(new ArrayList<Color>());
        this.textController.setAbsoluteBeginAddresses(new ArrayList<Integer>());
        this.textController.setAbsoluteEndAddresses(new ArrayList<Integer>());
        String myTextBuffer = this.textController.getMyText().buffer;
        for (int i = 0; i < theItems.size(); i += 4) {
            Object[] item = (Object[])theItems.get(i + 1);
            boolean isSelected = (Boolean)theItems.get(i + 2);
            if (!isSelected) continue;
            ArrayList annotation = (ArrayList)item[5];
            double absoluteBeginAddress0 = (Double)annotation.get(2);
            double absoluteEndAddress0 = (Double)annotation.get(3);
            int absoluteBeginAddress = (int)absoluteBeginAddress0;
            int absoluteEndAddress = (int)absoluteEndAddress0;
            if (absoluteBeginAddress0 != absoluteEndAddress0 && absoluteBeginAddress == absoluteEndAddress) {
                while (Language.isLetter(myTextBuffer.charAt(absoluteEndAddress))) {
                    ++absoluteEndAddress;
                }
            }
            this.textController.getListOfColors().add((Color)item[4]);
            this.textController.getAbsoluteBeginAddresses().add(absoluteBeginAddress);
            this.textController.getAbsoluteEndAddresses().add(absoluteEndAddress);
            this.textController.setColored(true);
        }
        TextEditorShell textShell = this.textController.getTextShell();
        UnitSelectionListener unitSelectionListener = textShell.getUnitSelectionListener();
        unitSelectionListener.paintTextInRGB();
        unitSelectionListener.partialColorText(this.textController, this.textController.getMyText(), textShell.getTextPane(), textShell, true);
    }

    public void loadConcordance(String fileName) {
        try {
            ConcordanceData cd = ConcordanceData.load(fileName);
            if (cd == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load concordance", "NooJ: file error", 0);
                return;
            }
            Launcher.getDesktopPane().add(this.concordanceShell);
            this.concordanceShell.setVisible(true);
            theItems.addAll(cd.getTheItems());
            this.refreshConcordance();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load concordance", "NooJ: file error", 0);
            return;
        }
    }

    public void saveConcordance() {
        if (Launcher.getSaveConcordanceChooser().showSaveDialog(null) != 0) {
            return;
        }
        File selectedFile = Launcher.getSaveConcordanceChooser().getSelectedFile();
        String fileName = FilenameUtils.removeExtension(selectedFile.getName()) + "." + "jncc";
        String parentPath = selectedFile.getParent();
        String filePath = parentPath + System.getProperty("file.separator") + fileName;
        if ((selectedFile = new File(filePath)).exists()) {
            int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), fileName + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
            if (value == 1 || value == -1) {
                return;
            }
            selectedFile.delete();
        }
        ConcordanceData cd = new ConcordanceData(this.textController.getFileToBeOpenedOrImported().getAbsolutePath(), theItems);
        try {
            cd.save(filePath);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot save concordance!", "ONooJ", 0);
            return;
        }
    }

    public void saveConcordanceForNooJ() {
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Not implemented!", "NooJ: cannot SaveForNooJ a concordance", 1);
    }

    public static void setBefore(int before) {
        ConcordanceShellController.before = before;
    }

    public static void setAfter(int after) {
        ConcordanceShellController.after = after;
    }

    public void setTheItems(List<Object> theItems) {
        ConcordanceShellController.theItems = theItems;
    }

    public static int getBefore() {
        return before;
    }

    public static int getAfter() {
        return after;
    }

    public ConcordanceShell getConcordanceShell() {
        return this.concordanceShell;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public void setCbMatchesIsPressed(boolean cbMatchesIsPressed) {
        this.cbMatchesIsPressed = cbMatchesIsPressed;
    }

    public List<Object> getTheItems() {
        return theItems;
    }

    public JTable getConcordanceTable() {
        return this.concordanceTable;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public boolean isCbMatchesIsPressed() {
        return this.cbMatchesIsPressed;
    }

    public boolean isRbCharactersIsPressed() {
        return this.rbCharactersIsPressed;
    }

    public boolean isCbOutputsIsPressed() {
        return this.cbOutputsIsPressed;
    }

    public void setCbOutputsIsPressed(boolean cbOutputsIsPressed) {
        this.cbOutputsIsPressed = cbOutputsIsPressed;
    }

    public Map<Color, Integer> getColorMap() {
        return this.colorMap;
    }

    public Language getLan() {
        return Lan;
    }

    public void setConcordanceTableSorted(boolean isConcordanceTableSorted) {
        this.isConcordanceTableSorted = isConcordanceTableSorted;
    }

    public void setConcordanceTable(JTable concordanceTable) {
        this.concordanceTable = concordanceTable;
    }

    public SyntacticTreeShell getSyntacticTreeShell() {
        return this.syntacticTreeShell;
    }

    public void setSyntacticTreeShell(SyntacticTreeShell syntacticTreeShell) {
        this.syntacticTreeShell = syntacticTreeShell;
    }

    static {
        theItems = null;
        before = 5;
        after = 5;
    }
}

